<?php

namespace MSML\BizTalk\Base\Type;

use Phpro\SoapClient\Type\RequestInterface;

class GetDocument implements RequestInterface
{
    /**
     * @var \MSML\BizTalk\Base\Type\GetDocumentQuery
     */
    private $invoiceNumber;

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Base\Type\GetDocumentQuery $invoiceNumber
     */
    public function __construct($invoiceNumber)
    {
        $this->invoiceNumber = $invoiceNumber;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\GetDocumentQuery
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\GetDocumentQuery $invoiceNumber
     * @return GetDocument
     */
    public function withInvoiceNumber($invoiceNumber)
    {
        $new = clone $this;
        $new->invoiceNumber = $invoiceNumber;

        return $new;
    }
}
