<?php

namespace MSML\BizTalk\Base\Type;

class GetDocumentResult
{
    /**
     * @var \MSML\BizTalk\Base\Type\Document
     */
    private $Document;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @return \MSML\BizTalk\Base\Type\Document
     */
    public function getDocument()
    {
        return $this->Document;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\Document $Document
     * @return GetDocumentResult
     */
    public function withDocument($Document)
    {
        $new = clone $this;
        $new->Document = $Document;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetDocumentResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }
}
