<?php

namespace MSML\BizTalk\Base\Type;

class GetInvoiceDetailsQuery
{
    /**
     * @var string
     */
    private $Division;

    /**
     * @var string
     */
    private $InvoiceNumber;

    /**
     * @var bool
     */
    private $IsFromOldNavision;

    /**
     * @var string
     */
    private $OldCustomerNumber;

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return GetInvoiceDetailsQuery
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }

    /**
     * @param string $InvoiceNumber
     * @return GetInvoiceDetailsQuery
     */
    public function withInvoiceNumber($InvoiceNumber)
    {
        $new = clone $this;
        $new->InvoiceNumber = $InvoiceNumber;

        return $new;
    }

    /**
     * @return bool
     */
    public function getIsFromOldNavision()
    {
        return $this->IsFromOldNavision;
    }

    /**
     * @param bool $IsFromOldNavision
     * @return GetInvoiceDetailsQuery
     */
    public function withIsFromOldNavision($IsFromOldNavision)
    {
        $new = clone $this;
        $new->IsFromOldNavision = $IsFromOldNavision;

        return $new;
    }

    /**
     * @return string
     */
    public function getOldCustomerNumber()
    {
        return $this->OldCustomerNumber;
    }

    /**
     * @param string $OldCustomerNumber
     * @return GetInvoiceDetailsQuery
     */
    public function withOldCustomerNumber($OldCustomerNumber)
    {
        $new = clone $this;
        $new->OldCustomerNumber = $OldCustomerNumber;

        return $new;
    }
}
