<?php

namespace MSML\BizTalk\Base\Type;

class GetInvoiceDetailsResult
{
    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Base\Type\DRRException
     */
    private $Exception;

    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfInvoiceLine
     */
    private $InvoiceLines;

    /**
     * @var string
     */
    private $InvoiceNumber;

    /**
     * @var string
     */
    private $RemainingAmount;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetInvoiceDetailsResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\DRRException
     */
    public function getException()
    {
        return $this->Exception;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\DRRException $Exception
     * @return GetInvoiceDetailsResult
     */
    public function withException($Exception)
    {
        $new = clone $this;
        $new->Exception = $Exception;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfInvoiceLine
     */
    public function getInvoiceLines()
    {
        return $this->InvoiceLines;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfInvoiceLine $InvoiceLines
     * @return GetInvoiceDetailsResult
     */
    public function withInvoiceLines($InvoiceLines)
    {
        $new = clone $this;
        $new->InvoiceLines = $InvoiceLines;

        return $new;
    }

    /**
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }

    /**
     * @param string $InvoiceNumber
     * @return GetInvoiceDetailsResult
     */
    public function withInvoiceNumber($InvoiceNumber)
    {
        $new = clone $this;
        $new->InvoiceNumber = $InvoiceNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getRemainingAmount()
    {
        return $this->RemainingAmount;
    }

    /**
     * @param string $RemainingAmount
     * @return GetInvoiceDetailsResult
     */
    public function withRemainingAmount($RemainingAmount)
    {
        $new = clone $this;
        $new->RemainingAmount = $RemainingAmount;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GetInvoiceDetailsResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
