<?php

namespace MSML\BizTalk\Base\Type;

class GetMaterialItem
{
    /**
     * @var string
     */
    private $ItemNo;

    /**
     * @var float
     */
    private $PriceExclVAT;

    /**
     * @var float
     */
    private $PriceInclVAT;

    /**
     * @return string
     */
    public function getItemNo()
    {
        return $this->ItemNo;
    }

    /**
     * @param string $ItemNo
     * @return GetMaterialItem
     */
    public function withItemNo($ItemNo)
    {
        $new = clone $this;
        $new->ItemNo = $ItemNo;

        return $new;
    }

    /**
     * @return float
     */
    public function getPriceExclVAT()
    {
        return $this->PriceExclVAT;
    }

    /**
     * @param float $PriceExclVAT
     * @return GetMaterialItem
     */
    public function withPriceExclVAT($PriceExclVAT)
    {
        $new = clone $this;
        $new->PriceExclVAT = $PriceExclVAT;

        return $new;
    }

    /**
     * @return float
     */
    public function getPriceInclVAT()
    {
        return $this->PriceInclVAT;
    }

    /**
     * @param float $PriceInclVAT
     * @return GetMaterialItem
     */
    public function withPriceInclVAT($PriceInclVAT)
    {
        $new = clone $this;
        $new->PriceInclVAT = $PriceInclVAT;

        return $new;
    }
}
