<?php

namespace MSML\BizTalk\Base\Type;

class GetOrderHistoryQuery
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var \DateTimeInterface
     */
    private $EarliestHistoryDate;

    /**
     * @var string
     */
    private $LanguageCode;

    /**
     * @var int
     */
    private $NumberOfPeriods;

    /**
     * @var string
     */
    private $OldCustomerNumber;

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetOrderHistoryQuery
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return GetOrderHistoryQuery
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getEarliestHistoryDate()
    {
        return $this->EarliestHistoryDate;
    }

    /**
     * @param \DateTimeInterface $EarliestHistoryDate
     * @return GetOrderHistoryQuery
     */
    public function withEarliestHistoryDate($EarliestHistoryDate)
    {
        $new = clone $this;
        $new->EarliestHistoryDate = $EarliestHistoryDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }

    /**
     * @param string $LanguageCode
     * @return GetOrderHistoryQuery
     */
    public function withLanguageCode($LanguageCode)
    {
        $new = clone $this;
        $new->LanguageCode = $LanguageCode;

        return $new;
    }

    /**
     * @return int
     */
    public function getNumberOfPeriods()
    {
        return $this->NumberOfPeriods;
    }

    /**
     * @param int $NumberOfPeriods
     * @return GetOrderHistoryQuery
     */
    public function withNumberOfPeriods($NumberOfPeriods)
    {
        $new = clone $this;
        $new->NumberOfPeriods = $NumberOfPeriods;

        return $new;
    }

    /**
     * @return string
     */
    public function getOldCustomerNumber()
    {
        return $this->OldCustomerNumber;
    }

    /**
     * @param string $OldCustomerNumber
     * @return GetOrderHistoryQuery
     */
    public function withOldCustomerNumber($OldCustomerNumber)
    {
        $new = clone $this;
        $new->OldCustomerNumber = $OldCustomerNumber;

        return $new;
    }
}
