<?php

namespace MSML\BizTalk\Base\Type;

class GetOrderHistoryResult
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Base\Type\DRRException
     */
    private $Exception;

    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfOrderHistoryItem
     */
    private $Items;

    /**
     * @var string
     */
    private $LanguageCode;

    /**
     * @var int
     */
    private $NumberOfPeriods;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @var \DateTimeInterface
     */
    private $StartDate;

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetOrderHistoryResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetOrderHistoryResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\DRRException
     */
    public function getException()
    {
        return $this->Exception;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\DRRException $Exception
     * @return GetOrderHistoryResult
     */
    public function withException($Exception)
    {
        $new = clone $this;
        $new->Exception = $Exception;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfOrderHistoryItem
     */
    public function getItems()
    {
        return $this->Items;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfOrderHistoryItem $Items
     * @return GetOrderHistoryResult
     */
    public function withItems($Items)
    {
        $new = clone $this;
        $new->Items = $Items;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }

    /**
     * @param string $LanguageCode
     * @return GetOrderHistoryResult
     */
    public function withLanguageCode($LanguageCode)
    {
        $new = clone $this;
        $new->LanguageCode = $LanguageCode;

        return $new;
    }

    /**
     * @return int
     */
    public function getNumberOfPeriods()
    {
        return $this->NumberOfPeriods;
    }

    /**
     * @param int $NumberOfPeriods
     * @return GetOrderHistoryResult
     */
    public function withNumberOfPeriods($NumberOfPeriods)
    {
        $new = clone $this;
        $new->NumberOfPeriods = $NumberOfPeriods;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GetOrderHistoryResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }

    /**
     * @param \DateTimeInterface $StartDate
     * @return GetOrderHistoryResult
     */
    public function withStartDate($StartDate)
    {
        $new = clone $this;
        $new->StartDate = $StartDate;

        return $new;
    }
}
