<?php

namespace MSML\BizTalk\Base\Type;

class GetPriceAndDiscountItem
{
    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfGetDiscountItem
     */
    private $Discount;

    /**
     * @var string
     */
    private $ItemCode;

    /**
     * @var string
     */
    private $ItemDescription;

    /**
     * @var \MSML\BizTalk\Base\Type\GetPriceItem
     */
    private $Price;

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfGetDiscountItem
     */
    public function getDiscount()
    {
        return $this->Discount;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfGetDiscountItem $Discount
     * @return GetPriceAndDiscountItem
     */
    public function withDiscount($Discount)
    {
        $new = clone $this;
        $new->Discount = $Discount;

        return $new;
    }

    /**
     * @return string
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }

    /**
     * @param string $ItemCode
     * @return GetPriceAndDiscountItem
     */
    public function withItemCode($ItemCode)
    {
        $new = clone $this;
        $new->ItemCode = $ItemCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getItemDescription()
    {
        return $this->ItemDescription;
    }

    /**
     * @param string $ItemDescription
     * @return GetPriceAndDiscountItem
     */
    public function withItemDescription($ItemDescription)
    {
        $new = clone $this;
        $new->ItemDescription = $ItemDescription;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\GetPriceItem
     */
    public function getPrice()
    {
        return $this->Price;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\GetPriceItem $Price
     * @return GetPriceAndDiscountItem
     */
    public function withPrice($Price)
    {
        $new = clone $this;
        $new->Price = $Price;

        return $new;
    }
}
