<?php

namespace MSML\BizTalk\Base\Type;

class GetPricesAndDiscountsResult
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $CustomerDiscGroup;

    /**
     * @var string
     */
    private $CustomerDiscGroupDescription;

    /**
     * @var string
     */
    private $CustomerPriceGroup;

    /**
     * @var string
     */
    private $CustomerPriceGroupDescription;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfGetPriceAndDiscountItem
     */
    private $Items;

    /**
     * @var string
     */
    private $LanguageCode;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetPricesAndDiscountsResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getCustomerDiscGroup()
    {
        return $this->CustomerDiscGroup;
    }

    /**
     * @param string $CustomerDiscGroup
     * @return GetPricesAndDiscountsResult
     */
    public function withCustomerDiscGroup($CustomerDiscGroup)
    {
        $new = clone $this;
        $new->CustomerDiscGroup = $CustomerDiscGroup;

        return $new;
    }

    /**
     * @return string
     */
    public function getCustomerDiscGroupDescription()
    {
        return $this->CustomerDiscGroupDescription;
    }

    /**
     * @param string $CustomerDiscGroupDescription
     * @return GetPricesAndDiscountsResult
     */
    public function withCustomerDiscGroupDescription($CustomerDiscGroupDescription)
    {
        $new = clone $this;
        $new->CustomerDiscGroupDescription = $CustomerDiscGroupDescription;

        return $new;
    }

    /**
     * @return string
     */
    public function getCustomerPriceGroup()
    {
        return $this->CustomerPriceGroup;
    }

    /**
     * @param string $CustomerPriceGroup
     * @return GetPricesAndDiscountsResult
     */
    public function withCustomerPriceGroup($CustomerPriceGroup)
    {
        $new = clone $this;
        $new->CustomerPriceGroup = $CustomerPriceGroup;

        return $new;
    }

    /**
     * @return string
     */
    public function getCustomerPriceGroupDescription()
    {
        return $this->CustomerPriceGroupDescription;
    }

    /**
     * @param string $CustomerPriceGroupDescription
     * @return GetPricesAndDiscountsResult
     */
    public function withCustomerPriceGroupDescription($CustomerPriceGroupDescription)
    {
        $new = clone $this;
        $new->CustomerPriceGroupDescription = $CustomerPriceGroupDescription;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetPricesAndDiscountsResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfGetPriceAndDiscountItem
     */
    public function getItems()
    {
        return $this->Items;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfGetPriceAndDiscountItem $Items
     * @return GetPricesAndDiscountsResult
     */
    public function withItems($Items)
    {
        $new = clone $this;
        $new->Items = $Items;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }

    /**
     * @param string $LanguageCode
     * @return GetPricesAndDiscountsResult
     */
    public function withLanguageCode($LanguageCode)
    {
        $new = clone $this;
        $new->LanguageCode = $LanguageCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GetPricesAndDiscountsResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
