<?php

namespace MSML\BizTalk\Base\Type;

class GetSalesHistoryResult
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfSalesHistoryItem
     */
    private $Item;

    /**
     * @var string
     */
    private $LanguageCode;

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetSalesHistoryResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetSalesHistoryResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfSalesHistoryItem
     */
    public function getItem()
    {
        return $this->Item;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfSalesHistoryItem $Item
     * @return GetSalesHistoryResult
     */
    public function withItem($Item)
    {
        $new = clone $this;
        $new->Item = $Item;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }

    /**
     * @param string $LanguageCode
     * @return GetSalesHistoryResult
     */
    public function withLanguageCode($LanguageCode)
    {
        $new = clone $this;
        $new->LanguageCode = $LanguageCode;

        return $new;
    }
}
