<?php

namespace MSML\BizTalk\Base\Type;

use Phpro\SoapClient\Type\RequestInterface;

class GetServiceContract implements RequestInterface
{
    /**
     * @var \MSML\BizTalk\Base\Type\GetServiceContractQuery
     */
    private $request;

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Base\Type\GetServiceContractQuery $request
     */
    public function __construct($request)
    {
        $this->request = $request;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\GetServiceContractQuery
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\GetServiceContractQuery $request
     * @return GetServiceContract
     */
    public function withRequest($request)
    {
        $new = clone $this;
        $new->request = $request;

        return $new;
    }
}
