<?php

namespace MSML\BizTalk\Base\Type;

class GetServiceContractResult
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfServiceContractHeader
     */
    private $Headers;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetServiceContractResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetServiceContractResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfServiceContractHeader
     */
    public function getHeaders()
    {
        return $this->Headers;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfServiceContractHeader $Headers
     * @return GetServiceContractResult
     */
    public function withHeaders($Headers)
    {
        $new = clone $this;
        $new->Headers = $Headers;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GetServiceContractResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
