<?php

namespace MSML\BizTalk\Base\Type;

use Phpro\SoapClient\Type\RequestInterface;

class GetServiceItem implements RequestInterface
{
    /**
     * @var \MSML\BizTalk\Base\Type\GetServiceItemQuery
     */
    private $request;

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Base\Type\GetServiceItemQuery $request
     */
    public function __construct($request)
    {
        $this->request = $request;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\GetServiceItemQuery
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\GetServiceItemQuery $request
     * @return GetServiceItem
     */
    public function withRequest($request)
    {
        $new = clone $this;
        $new->request = $request;

        return $new;
    }
}
