<?php

namespace MSML\BizTalk\Base\Type;

class GetServiceItemResult
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfServiceItem
     */
    private $Items;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetServiceItemResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetServiceItemResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfServiceItem
     */
    public function getItems()
    {
        return $this->Items;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfServiceItem $Items
     * @return GetServiceItemResult
     */
    public function withItems($Items)
    {
        $new = clone $this;
        $new->Items = $Items;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GetServiceItemResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
