<?php

namespace MSML\BizTalk\Base\Type;

class OrderHistoryItem
{
    /**
     * @var string
     */
    private $BaseUnitOfMeasure;

    /**
     * @var \DateTimeInterface
     */
    private $DeliveryDate;

    /**
     * @var \DateTimeInterface
     */
    private $FirstShipment;

    /**
     * @var string
     */
    private $LastShipment;

    /**
     * @var string
     */
    private $No;

    /**
     * @var float
     */
    private $NumberOfProducts;

    /**
     * @var \DateTimeInterface
     */
    private $OrderDate;

    /**
     * @var string
     */
    private $RideNumber;

    /**
     * @var string
     */
    private $Status;

    /**
     * @var string
     */
    private $TypeOfProduct;

    /**
     * @return string
     */
    public function getBaseUnitOfMeasure()
    {
        return $this->BaseUnitOfMeasure;
    }

    /**
     * @param string $BaseUnitOfMeasure
     * @return OrderHistoryItem
     */
    public function withBaseUnitOfMeasure($BaseUnitOfMeasure)
    {
        $new = clone $this;
        $new->BaseUnitOfMeasure = $BaseUnitOfMeasure;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }

    /**
     * @param \DateTimeInterface $DeliveryDate
     * @return OrderHistoryItem
     */
    public function withDeliveryDate($DeliveryDate)
    {
        $new = clone $this;
        $new->DeliveryDate = $DeliveryDate;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getFirstShipment()
    {
        return $this->FirstShipment;
    }

    /**
     * @param \DateTimeInterface $FirstShipment
     * @return OrderHistoryItem
     */
    public function withFirstShipment($FirstShipment)
    {
        $new = clone $this;
        $new->FirstShipment = $FirstShipment;

        return $new;
    }

    /**
     * @return string
     */
    public function getLastShipment()
    {
        return $this->LastShipment;
    }

    /**
     * @param string $LastShipment
     * @return OrderHistoryItem
     */
    public function withLastShipment($LastShipment)
    {
        $new = clone $this;
        $new->LastShipment = $LastShipment;

        return $new;
    }

    /**
     * @return string
     */
    public function getNo()
    {
        return $this->No;
    }

    /**
     * @param string $No
     * @return OrderHistoryItem
     */
    public function withNo($No)
    {
        $new = clone $this;
        $new->No = $No;

        return $new;
    }

    /**
     * @return float
     */
    public function getNumberOfProducts()
    {
        return $this->NumberOfProducts;
    }

    /**
     * @param float $NumberOfProducts
     * @return OrderHistoryItem
     */
    public function withNumberOfProducts($NumberOfProducts)
    {
        $new = clone $this;
        $new->NumberOfProducts = $NumberOfProducts;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getOrderDate()
    {
        return $this->OrderDate;
    }

    /**
     * @param \DateTimeInterface $OrderDate
     * @return OrderHistoryItem
     */
    public function withOrderDate($OrderDate)
    {
        $new = clone $this;
        $new->OrderDate = $OrderDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getRideNumber()
    {
        return $this->RideNumber;
    }

    /**
     * @param string $RideNumber
     * @return OrderHistoryItem
     */
    public function withRideNumber($RideNumber)
    {
        $new = clone $this;
        $new->RideNumber = $RideNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * @param string $Status
     * @return OrderHistoryItem
     */
    public function withStatus($Status)
    {
        $new = clone $this;
        $new->Status = $Status;

        return $new;
    }

    /**
     * @return string
     */
    public function getTypeOfProduct()
    {
        return $this->TypeOfProduct;
    }

    /**
     * @param string $TypeOfProduct
     * @return OrderHistoryItem
     */
    public function withTypeOfProduct($TypeOfProduct)
    {
        $new = clone $this;
        $new->TypeOfProduct = $TypeOfProduct;

        return $new;
    }
}
