<?php

namespace MSML\BizTalk\Base\Type;

class ResetPasswordResult
{
    /**
     * @var string
     */
    private $CUNumber;

    /**
     * @var string
     */
    private $EmailAddress;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return string
     */
    public function getCUNumber()
    {
        return $this->CUNumber;
    }

    /**
     * @param string $CUNumber
     * @return ResetPasswordResult
     */
    public function withCUNumber($CUNumber)
    {
        $new = clone $this;
        $new->CUNumber = $CUNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }

    /**
     * @param string $EmailAddress
     * @return ResetPasswordResult
     */
    public function withEmailAddress($EmailAddress)
    {
        $new = clone $this;
        $new->EmailAddress = $EmailAddress;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return ResetPasswordResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return ResetPasswordResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
