<?php

namespace MSML\BizTalk\Base\Type;

class SalesHistoryItem
{
    /**
     * @var string
     */
    private $BaseUOM;

    /**
     * @var string
     */
    private $Description;

    /**
     * @var string
     */
    private $No;

    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfSalesHistoryItemPeriod
     */
    private $Period;

    /**
     * @var string
     */
    private $SalesUOM;

    /**
     * @return string
     */
    public function getBaseUOM()
    {
        return $this->BaseUOM;
    }

    /**
     * @param string $BaseUOM
     * @return SalesHistoryItem
     */
    public function withBaseUOM($BaseUOM)
    {
        $new = clone $this;
        $new->BaseUOM = $BaseUOM;

        return $new;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * @param string $Description
     * @return SalesHistoryItem
     */
    public function withDescription($Description)
    {
        $new = clone $this;
        $new->Description = $Description;

        return $new;
    }

    /**
     * @return string
     */
    public function getNo()
    {
        return $this->No;
    }

    /**
     * @param string $No
     * @return SalesHistoryItem
     */
    public function withNo($No)
    {
        $new = clone $this;
        $new->No = $No;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfSalesHistoryItemPeriod
     */
    public function getPeriod()
    {
        return $this->Period;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfSalesHistoryItemPeriod $Period
     * @return SalesHistoryItem
     */
    public function withPeriod($Period)
    {
        $new = clone $this;
        $new->Period = $Period;

        return $new;
    }

    /**
     * @return string
     */
    public function getSalesUOM()
    {
        return $this->SalesUOM;
    }

    /**
     * @param string $SalesUOM
     * @return SalesHistoryItem
     */
    public function withSalesUOM($SalesUOM)
    {
        $new = clone $this;
        $new->SalesUOM = $SalesUOM;

        return $new;
    }
}
