<?php

namespace MSML\BizTalk\Base\Type;

class ServiceContractHeader
{
    /**
     * @var float
     */
    private $AnnualAmount;

    /**
     * @var string
     */
    private $CancelReasonCode;

    /**
     * @var string
     */
    private $ContractNo;

    /**
     * @var string
     */
    private $Description;

    /**
     * @var \DateTimeInterface
     */
    private $EndingDate;

    /**
     * @var float
     */
    private $ExpectedYearConsumption;

    /**
     * @var int
     */
    private $InvoicePeriod;

    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfServiceItem
     */
    private $Items;

    /**
     * @var string
     */
    private $PrimagazContractNo;

    /**
     * @var \DateTimeInterface
     */
    private $StartingDate;

    /**
     * @var string
     */
    private $Status;

    /**
     * @var string
     */
    private $YourReference;

    /**
     * @return float
     */
    public function getAnnualAmount()
    {
        return $this->AnnualAmount;
    }

    /**
     * @param float $AnnualAmount
     * @return ServiceContractHeader
     */
    public function withAnnualAmount($AnnualAmount)
    {
        $new = clone $this;
        $new->AnnualAmount = $AnnualAmount;

        return $new;
    }

    /**
     * @return string
     */
    public function getCancelReasonCode()
    {
        return $this->CancelReasonCode;
    }

    /**
     * @param string $CancelReasonCode
     * @return ServiceContractHeader
     */
    public function withCancelReasonCode($CancelReasonCode)
    {
        $new = clone $this;
        $new->CancelReasonCode = $CancelReasonCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getContractNo()
    {
        return $this->ContractNo;
    }

    /**
     * @param string $ContractNo
     * @return ServiceContractHeader
     */
    public function withContractNo($ContractNo)
    {
        $new = clone $this;
        $new->ContractNo = $ContractNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * @param string $Description
     * @return ServiceContractHeader
     */
    public function withDescription($Description)
    {
        $new = clone $this;
        $new->Description = $Description;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getEndingDate()
    {
        return $this->EndingDate;
    }

    /**
     * @param \DateTimeInterface $EndingDate
     * @return ServiceContractHeader
     */
    public function withEndingDate($EndingDate)
    {
        $new = clone $this;
        $new->EndingDate = $EndingDate;

        return $new;
    }

    /**
     * @return float
     */
    public function getExpectedYearConsumption()
    {
        return $this->ExpectedYearConsumption;
    }

    /**
     * @param float $ExpectedYearConsumption
     * @return ServiceContractHeader
     */
    public function withExpectedYearConsumption($ExpectedYearConsumption)
    {
        $new = clone $this;
        $new->ExpectedYearConsumption = $ExpectedYearConsumption;

        return $new;
    }

    /**
     * @return int
     */
    public function getInvoicePeriod()
    {
        return $this->InvoicePeriod;
    }

    /**
     * @param int $InvoicePeriod
     * @return ServiceContractHeader
     */
    public function withInvoicePeriod($InvoicePeriod)
    {
        $new = clone $this;
        $new->InvoicePeriod = $InvoicePeriod;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfServiceItem
     */
    public function getItems()
    {
        return $this->Items;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfServiceItem $Items
     * @return ServiceContractHeader
     */
    public function withItems($Items)
    {
        $new = clone $this;
        $new->Items = $Items;

        return $new;
    }

    /**
     * @return string
     */
    public function getPrimagazContractNo()
    {
        return $this->PrimagazContractNo;
    }

    /**
     * @param string $PrimagazContractNo
     * @return ServiceContractHeader
     */
    public function withPrimagazContractNo($PrimagazContractNo)
    {
        $new = clone $this;
        $new->PrimagazContractNo = $PrimagazContractNo;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getStartingDate()
    {
        return $this->StartingDate;
    }

    /**
     * @param \DateTimeInterface $StartingDate
     * @return ServiceContractHeader
     */
    public function withStartingDate($StartingDate)
    {
        $new = clone $this;
        $new->StartingDate = $StartingDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * @param string $Status
     * @return ServiceContractHeader
     */
    public function withStatus($Status)
    {
        $new = clone $this;
        $new->Status = $Status;

        return $new;
    }

    /**
     * @return string
     */
    public function getYourReference()
    {
        return $this->YourReference;
    }

    /**
     * @param string $YourReference
     * @return ServiceContractHeader
     */
    public function withYourReference($YourReference)
    {
        $new = clone $this;
        $new->YourReference = $YourReference;

        return $new;
    }
}
