<?php

namespace MSML\BizTalk\Base\Type;

class ServiceItem
{
    /**
     * @var string
     */
    private $Description;

    /**
     * @var string
     */
    private $GasMeterNo;

    /**
     * @var \DateTimeInterface
     */
    private $LastRefDate;

    /**
     * @var string
     */
    private $LastRefLevel;

    /**
     * @var string
     */
    private $Name;

    /**
     * @var string
     */
    private $No;

    /**
     * @var string
     */
    private $SerialNo;

    /**
     * @var \DateTimeInterface
     */
    private $SettlementDate;

    /**
     * @var string
     */
    private $Type;

    /**
     * @var string
     */
    private $Volume;

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * @param string $Description
     * @return ServiceItem
     */
    public function withDescription($Description)
    {
        $new = clone $this;
        $new->Description = $Description;

        return $new;
    }

    /**
     * @return string
     */
    public function getGasMeterNo()
    {
        return $this->GasMeterNo;
    }

    /**
     * @param string $GasMeterNo
     * @return ServiceItem
     */
    public function withGasMeterNo($GasMeterNo)
    {
        $new = clone $this;
        $new->GasMeterNo = $GasMeterNo;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getLastRefDate()
    {
        return $this->LastRefDate;
    }

    /**
     * @param \DateTimeInterface $LastRefDate
     * @return ServiceItem
     */
    public function withLastRefDate($LastRefDate)
    {
        $new = clone $this;
        $new->LastRefDate = $LastRefDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getLastRefLevel()
    {
        return $this->LastRefLevel;
    }

    /**
     * @param string $LastRefLevel
     * @return ServiceItem
     */
    public function withLastRefLevel($LastRefLevel)
    {
        $new = clone $this;
        $new->LastRefLevel = $LastRefLevel;

        return $new;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }

    /**
     * @param string $Name
     * @return ServiceItem
     */
    public function withName($Name)
    {
        $new = clone $this;
        $new->Name = $Name;

        return $new;
    }

    /**
     * @return string
     */
    public function getNo()
    {
        return $this->No;
    }

    /**
     * @param string $No
     * @return ServiceItem
     */
    public function withNo($No)
    {
        $new = clone $this;
        $new->No = $No;

        return $new;
    }

    /**
     * @return string
     */
    public function getSerialNo()
    {
        return $this->SerialNo;
    }

    /**
     * @param string $SerialNo
     * @return ServiceItem
     */
    public function withSerialNo($SerialNo)
    {
        $new = clone $this;
        $new->SerialNo = $SerialNo;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getSettlementDate()
    {
        return $this->SettlementDate;
    }

    /**
     * @param \DateTimeInterface $SettlementDate
     * @return ServiceItem
     */
    public function withSettlementDate($SettlementDate)
    {
        $new = clone $this;
        $new->SettlementDate = $SettlementDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }

    /**
     * @param string $Type
     * @return ServiceItem
     */
    public function withType($Type)
    {
        $new = clone $this;
        $new->Type = $Type;

        return $new;
    }

    /**
     * @return string
     */
    public function getVolume()
    {
        return $this->Volume;
    }

    /**
     * @param string $Volume
     * @return ServiceItem
     */
    public function withVolume($Volume)
    {
        $new = clone $this;
        $new->Volume = $Volume;

        return $new;
    }
}
