<?php

namespace MSML\BizTalk\Base\Type;

class ShipToAddress
{
    /**
     * @var string
     */
    private $Address;

    /**
     * @var string
     */
    private $Address2;

    /**
     * @var string
     */
    private $AddressType;

    /**
     * @var string
     */
    private $City;

    /**
     * @var int
     */
    private $Code;

    /**
     * @var string
     */
    private $CountryRegionCode;

    /**
     * @var string
     */
    private $Name;

    /**
     * @var string
     */
    private $PostCode;

    /**
     * @var string
     */
    private $YourReference;

    /**
     * @return string
     */
    public function getAddress()
    {
        return $this->Address;
    }

    /**
     * @param string $Address
     * @return ShipToAddress
     */
    public function withAddress($Address)
    {
        $new = clone $this;
        $new->Address = $Address;

        return $new;
    }

    /**
     * @return string
     */
    public function getAddress2()
    {
        return $this->Address2;
    }

    /**
     * @param string $Address2
     * @return ShipToAddress
     */
    public function withAddress2($Address2)
    {
        $new = clone $this;
        $new->Address2 = $Address2;

        return $new;
    }

    /**
     * @return string
     */
    public function getAddressType()
    {
        return $this->AddressType;
    }

    /**
     * @param string $AddressType
     * @return ShipToAddress
     */
    public function withAddressType($AddressType)
    {
        $new = clone $this;
        $new->AddressType = $AddressType;

        return $new;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }

    /**
     * @param string $City
     * @return ShipToAddress
     */
    public function withCity($City)
    {
        $new = clone $this;
        $new->City = $City;

        return $new;
    }

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }

    /**
     * @param int $Code
     * @return ShipToAddress
     */
    public function withCode($Code)
    {
        $new = clone $this;
        $new->Code = $Code;

        return $new;
    }

    /**
     * @return string
     */
    public function getCountryRegionCode()
    {
        return $this->CountryRegionCode;
    }

    /**
     * @param string $CountryRegionCode
     * @return ShipToAddress
     */
    public function withCountryRegionCode($CountryRegionCode)
    {
        $new = clone $this;
        $new->CountryRegionCode = $CountryRegionCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }

    /**
     * @param string $Name
     * @return ShipToAddress
     */
    public function withName($Name)
    {
        $new = clone $this;
        $new->Name = $Name;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }

    /**
     * @param string $PostCode
     * @return ShipToAddress
     */
    public function withPostCode($PostCode)
    {
        $new = clone $this;
        $new->PostCode = $PostCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getYourReference()
    {
        return $this->YourReference;
    }

    /**
     * @param string $YourReference
     * @return ShipToAddress
     */
    public function withYourReference($YourReference)
    {
        $new = clone $this;
        $new->YourReference = $YourReference;

        return $new;
    }
}
