<?php

namespace MSML\BizTalk\Base\Type;

class TelemetryHistoryResult
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfFuelTankHistory
     */
    private $History;

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return TelemetryHistoryResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return TelemetryHistoryResult
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return TelemetryHistoryResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfFuelTankHistory
     */
    public function getHistory()
    {
        return $this->History;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfFuelTankHistory $History
     * @return TelemetryHistoryResult
     */
    public function withHistory($History)
    {
        $new = clone $this;
        $new->History = $History;

        return $new;
    }
}
