<?php

namespace MSML\BizTalk\Base\Type;

class VerifyLoginQuery
{
    /**
     * @var string
     */
    private $Password;

    /**
     * @var string
     */
    private $UserName;

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }

    /**
     * @param string $Password
     * @return VerifyLoginQuery
     */
    public function withPassword($Password)
    {
        $new = clone $this;
        $new->Password = $Password;

        return $new;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->UserName;
    }

    /**
     * @param string $UserName
     * @return VerifyLoginQuery
     */
    public function withUserName($UserName)
    {
        $new = clone $this;
        $new->UserName = $UserName;

        return $new;
    }
}
