<?php

namespace MSML\BizTalk;

use MSML\BizTalk\Base\BaseClientFactory;
use MSML\BizTalk\Order\OrderClientFactory;
use MSML\BizTalk\Contact\ContactClientFactory;
use MSML\BizTalk\BottleOrder\BottleOrderClientFactory;
use MSML\BizTalk\GasMeterScore\GasMeterScoreClientFactory;
use MSML\BizTalk\MaterialOrder\MaterialOrderClientFactory;
use MSML\BizTalk\PrimaryContact\PrimaryContactClientFactory;
use MSML\BizTalk\ShippingContact\ShippingContactClientFactory;

class BizTalkClientFactory
{
    public static function base(string $wsdl)
    {
        return BaseClientFactory::factory($wsdl);
    }

    public static function order(string $wsdl)
    {
        return OrderClientFactory::factory($wsdl);
    }

    public static function contact(string $wsdl)
    {
        return ContactClientFactory::factory($wsdl);
    }

    public static function primaryContact(string $wsdl)
    {
        return PrimaryContactClientFactory::factory($wsdl);
    }

    public static function materialOrder(string $wsdl)
    {
        return MaterialOrderClientFactory::factory($wsdl);
    }

    public static function bottleOrder(string $wsdl)
    {
        return BottleOrderClientFactory::factory($wsdl);
    }

    public static function gasMeterScore(string $wsdl)
    {
        return GasMeterScoreClientFactory::factory($wsdl);
    }

    public static function shippingContact(string $wsdl)
    {
        return ShippingContactClientFactory::factory($wsdl);
    }
}
