<?php

namespace MSML\BizTalk\BottleOrder;

use Soap\ExtSoapEngine\ExtSoapOptions;
use Phpro\SoapClient\Caller\EngineCaller;
use Phpro\SoapClient\Soap\DefaultEngineFactory;
use Phpro\SoapClient\Caller\EventDispatchingCaller;
use Symfony\Component\EventDispatcher\EventDispatcher;

class BottleOrderClientFactory
{
    public static function factory(string $wsdl) : \MSML\BizTalk\BottleOrder\BottleOrderClient
    {
        $engine = DefaultEngineFactory::create(
            ExtSoapOptions::defaults($wsdl, [])
                ->withClassMap(BottleOrderClassmap::getCollection())
        );

        $eventDispatcher = new EventDispatcher();
        $caller = new EventDispatchingCaller(new EngineCaller($engine), $eventDispatcher);

        return new BottleOrderClient($caller);
    }
}
