<?php

namespace MSML\BizTalk\BottleOrder\Type;

class CollectFaulty
{
    /**
     * @var string
     */
    private $itemNo;

    /**
     * @var float
     */
    private $quantity;

    /**
     * @return string
     */
    public function getItemNo()
    {
        return $this->itemNo;
    }

    /**
     * @param string $itemNo
     * @return CollectFaulty
     */
    public function withItemNo($itemNo)
    {
        $new = clone $this;
        $new->itemNo = $itemNo;

        return $new;
    }

    /**
     * @return float
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param float $quantity
     * @return CollectFaulty
     */
    public function withQuantity($quantity)
    {
        $new = clone $this;
        $new->quantity = $quantity;

        return $new;
    }
}
