<?php

namespace MSML\BizTalk\BottleOrder\Type;

use Phpro\SoapClient\Type\RequestInterface;

class CreateBottleOrderRequest implements RequestInterface
{
    /**
     * @var string
     */
    private $createdByNo;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var string
     */
    private $invoiceNo;

    /**
     * @var string
     */
    private $deliveryNo;

    /**
     * @var string
     */
    private $userName;

    /**
     * @var string
     */
    private $remarks;

    /**
     * @var string
     */
    private $yourReference;

    /**
     * @var \MSML\BizTalk\BottleOrder\Type\OrderLine
     */
    private $orderLine;

    /**
     * Constructor
     *
     * @var string $createdByNo
     * @var string $Division
     * @var string $invoiceNo
     * @var string $deliveryNo
     * @var string $userName
     * @var string $remarks
     * @var string $yourReference
     * @var \MSML\BizTalk\BottleOrder\Type\OrderLine $orderLine
     */
    public function __construct($createdByNo, $Division, $invoiceNo, $deliveryNo, $userName, $remarks, $yourReference, $orderLine)
    {
        $this->createdByNo = $createdByNo;
        $this->Division = $Division;
        $this->invoiceNo = $invoiceNo;
        $this->deliveryNo = $deliveryNo;
        $this->userName = $userName;
        $this->remarks = $remarks;
        $this->yourReference = $yourReference;
        $this->orderLine = $orderLine;
    }

    /**
     * @return string
     */
    public function getCreatedByNo()
    {
        return $this->createdByNo;
    }

    /**
     * @param string $createdByNo
     * @return CreateBottleOrderRequest
     */
    public function withCreatedByNo($createdByNo)
    {
        $new = clone $this;
        $new->createdByNo = $createdByNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return CreateBottleOrderRequest
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return string
     */
    public function getInvoiceNo()
    {
        return $this->invoiceNo;
    }

    /**
     * @param string $invoiceNo
     * @return CreateBottleOrderRequest
     */
    public function withInvoiceNo($invoiceNo)
    {
        $new = clone $this;
        $new->invoiceNo = $invoiceNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getDeliveryNo()
    {
        return $this->deliveryNo;
    }

    /**
     * @param string $deliveryNo
     * @return CreateBottleOrderRequest
     */
    public function withDeliveryNo($deliveryNo)
    {
        $new = clone $this;
        $new->deliveryNo = $deliveryNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param string $userName
     * @return CreateBottleOrderRequest
     */
    public function withUserName($userName)
    {
        $new = clone $this;
        $new->userName = $userName;

        return $new;
    }

    /**
     * @return string
     */
    public function getRemarks()
    {
        return $this->remarks;
    }

    /**
     * @param string $remarks
     * @return CreateBottleOrderRequest
     */
    public function withRemarks($remarks)
    {
        $new = clone $this;
        $new->remarks = $remarks;

        return $new;
    }

    /**
     * @return string
     */
    public function getYourReference()
    {
        return $this->yourReference;
    }

    /**
     * @param string $yourReference
     * @return CreateBottleOrderRequest
     */
    public function withYourReference($yourReference)
    {
        $new = clone $this;
        $new->yourReference = $yourReference;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\BottleOrder\Type\OrderLine
     */
    public function getOrderLine()
    {
        return $this->orderLine;
    }

    /**
     * @param \MSML\BizTalk\BottleOrder\Type\OrderLine $orderLine
     * @return CreateBottleOrderRequest
     */
    public function withOrderLine($orderLine)
    {
        $new = clone $this;
        $new->orderLine = $orderLine;

        return $new;
    }
}
