<?php

namespace MSML\BizTalk\BottleOrder\Type;

class OrderLine
{
    /**
     * @var string
     */
    private $itemNo;

    /**
     * @var float
     */
    private $quantity;

    /**
     * @var \MSML\BizTalk\BottleOrder\Type\CollectEmpty
     */
    private $collectEmpty;

    /**
     * @var \MSML\BizTalk\BottleOrder\Type\CollectFaulty
     */
    private $collectFaulty;

    /**
     * @return string
     */
    public function getItemNo()
    {
        return $this->itemNo;
    }

    /**
     * @param string $itemNo
     * @return OrderLine
     */
    public function withItemNo($itemNo)
    {
        $new = clone $this;
        $new->itemNo = $itemNo;

        return $new;
    }

    /**
     * @return float
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param float $quantity
     * @return OrderLine
     */
    public function withQuantity($quantity)
    {
        $new = clone $this;
        $new->quantity = $quantity;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\BottleOrder\Type\CollectEmpty
     */
    public function getCollectEmpty()
    {
        return $this->collectEmpty;
    }

    /**
     * @param \MSML\BizTalk\BottleOrder\Type\CollectEmpty $collectEmpty
     * @return OrderLine
     */
    public function withCollectEmpty($collectEmpty)
    {
        $new = clone $this;
        $new->collectEmpty = $collectEmpty;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\BottleOrder\Type\CollectFaulty
     */
    public function getCollectFaulty()
    {
        return $this->collectFaulty;
    }

    /**
     * @param \MSML\BizTalk\BottleOrder\Type\CollectFaulty $collectFaulty
     * @return OrderLine
     */
    public function withCollectFaulty($collectFaulty)
    {
        $new = clone $this;
        $new->collectFaulty = $collectFaulty;

        return $new;
    }
}
