<?php

namespace MSML\BizTalk\Contact;

use Soap\ExtSoapEngine\ExtSoapOptions;
use Phpro\SoapClient\Caller\EngineCaller;
use Phpro\SoapClient\Soap\DefaultEngineFactory;
use Phpro\SoapClient\Caller\EventDispatchingCaller;
use Symfony\Component\EventDispatcher\EventDispatcher;

class ContactClientFactory
{
    public static function factory(string $wsdl) : \MSML\BizTalk\Contact\ContactClient
    {
        $engine = DefaultEngineFactory::create(
            ExtSoapOptions::defaults($wsdl, [])
                ->withClassMap(ContactClassmap::getCollection())
        );

        $eventDispatcher = new EventDispatcher();
        $caller = new EventDispatchingCaller(new EngineCaller($engine), $eventDispatcher);

        return new ContactClient($caller);
    }
}
