<?php

namespace MSML\BizTalk\Contact\Type;

use Phpro\SoapClient\Type\RequestInterface;

class UpdateContactRequest implements RequestInterface
{
    /**
     * @var \DateTimeInterface
     */
    private $BirthDate;

    /**
     * @var string
     */
    private $ContactId;

    /**
     * @var string
     */
    private $ContactPersonStatus;

    /**
     * @var bool
     */
    private $DoNotCall;

    /**
     * @var string
     */
    private $Email;

    /**
     * @var string
     */
    private $FirstName;

    /**
     * @var bool
     */
    private $HasOptedOutOfEmail;

    /**
     * @var string
     */
    private $Language;

    /**
     * @var string
     */
    private $LastLogin;

    /**
     * @var string
     */
    private $LastName;

    /**
     * @var string
     */
    private $MobilePhone;

    /**
     * @var string
     */
    private $MyPrimagazAccountStatus;

    /**
     * @var string
     */
    private $Phone;

    /**
     * @var string
     */
    private $Salutation;

    /**
     * Constructor
     *
     * @var \DateTimeInterface $BirthDate
     * @var string $ContactId
     * @var string $ContactPersonStatus
     * @var bool $DoNotCall
     * @var string $Email
     * @var string $FirstName
     * @var bool $HasOptedOutOfEmail
     * @var string $Language
     * @var string $LastLogin
     * @var string $LastName
     * @var string $MobilePhone
     * @var string $MyPrimagazAccountStatus
     * @var string $Phone
     * @var string $Salutation
     */
    public function __construct($BirthDate, $ContactId, $ContactPersonStatus, $DoNotCall, $Email, $FirstName, $HasOptedOutOfEmail, $Language, $LastLogin, $LastName, $MobilePhone, $MyPrimagazAccountStatus, $Phone, $Salutation)
    {
        $this->BirthDate = $BirthDate;
        $this->ContactId = $ContactId;
        $this->ContactPersonStatus = $ContactPersonStatus;
        $this->DoNotCall = $DoNotCall;
        $this->Email = $Email;
        $this->FirstName = $FirstName;
        $this->HasOptedOutOfEmail = $HasOptedOutOfEmail;
        $this->Language = $Language;
        $this->LastLogin = $LastLogin;
        $this->LastName = $LastName;
        $this->MobilePhone = $MobilePhone;
        $this->MyPrimagazAccountStatus = $MyPrimagazAccountStatus;
        $this->Phone = $Phone;
        $this->Salutation = $Salutation;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }

    /**
     * @param \DateTimeInterface $BirthDate
     * @return UpdateContactRequest
     */
    public function withBirthDate($BirthDate)
    {
        $new = clone $this;
        $new->BirthDate = $BirthDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getContactId()
    {
        return $this->ContactId;
    }

    /**
     * @param string $ContactId
     * @return UpdateContactRequest
     */
    public function withContactId($ContactId)
    {
        $new = clone $this;
        $new->ContactId = $ContactId;

        return $new;
    }

    /**
     * @return string
     */
    public function getContactPersonStatus()
    {
        return $this->ContactPersonStatus;
    }

    /**
     * @param string $ContactPersonStatus
     * @return UpdateContactRequest
     */
    public function withContactPersonStatus($ContactPersonStatus)
    {
        $new = clone $this;
        $new->ContactPersonStatus = $ContactPersonStatus;

        return $new;
    }

    /**
     * @return bool
     */
    public function getDoNotCall()
    {
        return $this->DoNotCall;
    }

    /**
     * @param bool $DoNotCall
     * @return UpdateContactRequest
     */
    public function withDoNotCall($DoNotCall)
    {
        $new = clone $this;
        $new->DoNotCall = $DoNotCall;

        return $new;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->Email;
    }

    /**
     * @param string $Email
     * @return UpdateContactRequest
     */
    public function withEmail($Email)
    {
        $new = clone $this;
        $new->Email = $Email;

        return $new;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }

    /**
     * @param string $FirstName
     * @return UpdateContactRequest
     */
    public function withFirstName($FirstName)
    {
        $new = clone $this;
        $new->FirstName = $FirstName;

        return $new;
    }

    /**
     * @return bool
     */
    public function getHasOptedOutOfEmail()
    {
        return $this->HasOptedOutOfEmail;
    }

    /**
     * @param bool $HasOptedOutOfEmail
     * @return UpdateContactRequest
     */
    public function withHasOptedOutOfEmail($HasOptedOutOfEmail)
    {
        $new = clone $this;
        $new->HasOptedOutOfEmail = $HasOptedOutOfEmail;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguage()
    {
        return $this->Language;
    }

    /**
     * @param string $Language
     * @return UpdateContactRequest
     */
    public function withLanguage($Language)
    {
        $new = clone $this;
        $new->Language = $Language;

        return $new;
    }

    /**
     * @return string
     */
    public function getLastLogin()
    {
        return $this->LastLogin;
    }

    /**
     * @param string $LastLogin
     * @return UpdateContactRequest
     */
    public function withLastLogin($LastLogin)
    {
        $new = clone $this;
        $new->LastLogin = $LastLogin;

        return $new;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->LastName;
    }

    /**
     * @param string $LastName
     * @return UpdateContactRequest
     */
    public function withLastName($LastName)
    {
        $new = clone $this;
        $new->LastName = $LastName;

        return $new;
    }

    /**
     * @return string
     */
    public function getMobilePhone()
    {
        return $this->MobilePhone;
    }

    /**
     * @param string $MobilePhone
     * @return UpdateContactRequest
     */
    public function withMobilePhone($MobilePhone)
    {
        $new = clone $this;
        $new->MobilePhone = $MobilePhone;

        return $new;
    }

    /**
     * @return string
     */
    public function getMyPrimagazAccountStatus()
    {
        return $this->MyPrimagazAccountStatus;
    }

    /**
     * @param string $MyPrimagazAccountStatus
     * @return UpdateContactRequest
     */
    public function withMyPrimagazAccountStatus($MyPrimagazAccountStatus)
    {
        $new = clone $this;
        $new->MyPrimagazAccountStatus = $MyPrimagazAccountStatus;

        return $new;
    }

    /**
     * @return string
     */
    public function getPhone()
    {
        return $this->Phone;
    }

    /**
     * @param string $Phone
     * @return UpdateContactRequest
     */
    public function withPhone($Phone)
    {
        $new = clone $this;
        $new->Phone = $Phone;

        return $new;
    }

    /**
     * @return string
     */
    public function getSalutation()
    {
        return $this->Salutation;
    }

    /**
     * @param string $Salutation
     * @return UpdateContactRequest
     */
    public function withSalutation($Salutation)
    {
        $new = clone $this;
        $new->Salutation = $Salutation;

        return $new;
    }
}
