<?php

namespace MSML\BizTalk\GasMeterScore\Type;

use Phpro\SoapClient\Type\RequestInterface;

class CreateGasMeterScoreRequest implements RequestInterface
{
    /**
     * @var string
     */
    private $CustomerNumber;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var string
     */
    private $GasMeterNumber;

    /**
     * @var \DateTimeInterface
     */
    private $RecordingDate;

    /**
     * @var float
     */
    private $Score;

    /**
     * Constructor
     *
     * @var string $CustomerNumber
     * @var string $Division
     * @var string $GasMeterNumber
     * @var \DateTimeInterface $RecordingDate
     * @var float $Score
     */
    public function __construct($CustomerNumber, $Division, $GasMeterNumber, $RecordingDate, $Score)
    {
        $this->CustomerNumber = $CustomerNumber;
        $this->Division = $Division;
        $this->GasMeterNumber = $GasMeterNumber;
        $this->RecordingDate = $RecordingDate;
        $this->Score = $Score;
    }

    /**
     * @return string
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }

    /**
     * @param string $CustomerNumber
     * @return CreateGasMeterScoreRequest
     */
    public function withCustomerNumber($CustomerNumber)
    {
        $new = clone $this;
        $new->CustomerNumber = $CustomerNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return CreateGasMeterScoreRequest
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return string
     */
    public function getGasMeterNumber()
    {
        return $this->GasMeterNumber;
    }

    /**
     * @param string $GasMeterNumber
     * @return CreateGasMeterScoreRequest
     */
    public function withGasMeterNumber($GasMeterNumber)
    {
        $new = clone $this;
        $new->GasMeterNumber = $GasMeterNumber;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getRecordingDate()
    {
        return $this->RecordingDate;
    }

    /**
     * @param \DateTimeInterface $RecordingDate
     * @return CreateGasMeterScoreRequest
     */
    public function withRecordingDate($RecordingDate)
    {
        $new = clone $this;
        $new->RecordingDate = $RecordingDate;

        return $new;
    }

    /**
     * @return float
     */
    public function getScore()
    {
        return $this->Score;
    }

    /**
     * @param float $Score
     * @return CreateGasMeterScoreRequest
     */
    public function withScore($Score)
    {
        $new = clone $this;
        $new->Score = $Score;

        return $new;
    }
}
