<?php

namespace MSML\BizTalk\MaterialOrder;

use Phpro\SoapClient\Caller\Caller;
use Phpro\SoapClient\Type\ResultInterface;
use Phpro\SoapClient\Type\RequestInterface;
use Phpro\SoapClient\Exception\SoapException;

class MaterialOrderClient
{
    /**
     * @var Caller
     */
    private $caller;

    public function __construct(\Phpro\SoapClient\Caller\Caller $caller)
    {
        $this->caller = $caller;
    }

    /**
     * @param RequestInterface|Type\CreateMaterialOrderRequest $part
     * @return ResultInterface|Type\AnyType
     * @throws SoapException
     */
    public function createMaterialOrder(\MSML\BizTalk\MaterialOrder\Type\CreateMaterialOrderRequest $part)
    {
        return ($this->caller)('CreateMaterialOrder', $part);
    }
}
