<?php

namespace MSML\BizTalk\MaterialOrder;

use Soap\ExtSoapEngine\ExtSoapOptions;
use Phpro\SoapClient\Caller\EngineCaller;
use Phpro\SoapClient\Soap\DefaultEngineFactory;
use Phpro\SoapClient\Caller\EventDispatchingCaller;
use Symfony\Component\EventDispatcher\EventDispatcher;

class MaterialOrderClientFactory
{
    public static function factory(string $wsdl) : \MSML\BizTalk\MaterialOrder\MaterialOrderClient
    {
        $engine = DefaultEngineFactory::create(
            ExtSoapOptions::defaults($wsdl, [])
                ->withClassMap(MaterialOrderClassmap::getCollection())
        );

        $eventDispatcher = new EventDispatcher();
        $caller = new EventDispatchingCaller(new EngineCaller($engine), $eventDispatcher);

        return new MaterialOrderClient($caller);
    }
}
