<?php

namespace MSML\BizTalk\MaterialOrder\Type;

class OrderLine
{
    /**
     * @var string
     */
    private $itemNo;

    /**
     * @var float
     */
    private $quantity;

    /**
     * @return string
     */
    public function getItemNo()
    {
        return $this->itemNo;
    }

    /**
     * @param string $itemNo
     * @return OrderLine
     */
    public function withItemNo($itemNo)
    {
        $new = clone $this;
        $new->itemNo = $itemNo;

        return $new;
    }

    /**
     * @return float
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param float $quantity
     * @return OrderLine
     */
    public function withQuantity($quantity)
    {
        $new = clone $this;
        $new->quantity = $quantity;

        return $new;
    }
}
