<?php

namespace MSML\BizTalk\Order;

use Phpro\SoapClient\Caller\Caller;
use Phpro\SoapClient\Type\ResultInterface;
use Phpro\SoapClient\Type\RequestInterface;
use Phpro\SoapClient\Exception\SoapException;

class OrderClient
{
    /**
     * @var Caller
     */
    private $caller;

    public function __construct(\Phpro\SoapClient\Caller\Caller $caller)
    {
        $this->caller = $caller;
    }

    /**
     * @param RequestInterface|Type\CreateOrderRequest $part
     * @return ResultInterface|Type\CreateOrderResponse
     * @throws SoapException
     */
    public function createOrder(\MSML\BizTalk\Order\Type\CreateOrderRequest $part) : \MSML\BizTalk\Order\Type\CreateOrderResponse
    {
        return ($this->caller)('CreateOrder', $part);
    }
}
