<?php

namespace MSML\BizTalk\Order\Type;

use Phpro\SoapClient\Type\RequestInterface;

class CreateOrderRequest implements RequestInterface
{
    /**
     * @var string
     */
    private $createdByNo;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var string
     */
    private $invoiceNo;

    /**
     * @var string
     */
    private $deliveryNo;

    /**
     * @var string
     */
    private $userName;

    /**
     * @var float
     */
    private $tankPercentage;

    /**
     * @var string
     */
    private $remarks;

    /**
     * @var string
     */
    private $tankNo;

    /**
     * @var string
     */
    private $commentForTripPlanning;

    /**
     * @var string
     */
    private $yourReference;

    /**
     * @var string
     */
    private $OrderQty;

    /**
     * Constructor
     *
     * @var string $createdByNo
     * @var string $Division
     * @var string $invoiceNo
     * @var string $deliveryNo
     * @var string $userName
     * @var float $tankPercentage
     * @var string $remarks
     * @var string $tankNo
     * @var string $commentForTripPlanning
     * @var string $yourReference
     * @var string $OrderQty
     */
    public function __construct($createdByNo, $Division, $invoiceNo, $deliveryNo, $userName, $tankPercentage, $remarks, $tankNo, $commentForTripPlanning, $yourReference, $OrderQty)
    {
        $this->createdByNo = $createdByNo;
        $this->Division = $Division;
        $this->invoiceNo = $invoiceNo;
        $this->deliveryNo = $deliveryNo;
        $this->userName = $userName;
        $this->tankPercentage = $tankPercentage;
        $this->remarks = $remarks;
        $this->tankNo = $tankNo;
        $this->commentForTripPlanning = $commentForTripPlanning;
        $this->yourReference = $yourReference;
        $this->OrderQty = $OrderQty;
    }

    /**
     * @return string
     */
    public function getCreatedByNo()
    {
        return $this->createdByNo;
    }

    /**
     * @param string $createdByNo
     * @return CreateOrderRequest
     */
    public function withCreatedByNo($createdByNo)
    {
        $new = clone $this;
        $new->createdByNo = $createdByNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return CreateOrderRequest
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return string
     */
    public function getInvoiceNo()
    {
        return $this->invoiceNo;
    }

    /**
     * @param string $invoiceNo
     * @return CreateOrderRequest
     */
    public function withInvoiceNo($invoiceNo)
    {
        $new = clone $this;
        $new->invoiceNo = $invoiceNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getDeliveryNo()
    {
        return $this->deliveryNo;
    }

    /**
     * @param string $deliveryNo
     * @return CreateOrderRequest
     */
    public function withDeliveryNo($deliveryNo)
    {
        $new = clone $this;
        $new->deliveryNo = $deliveryNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param string $userName
     * @return CreateOrderRequest
     */
    public function withUserName($userName)
    {
        $new = clone $this;
        $new->userName = $userName;

        return $new;
    }

    /**
     * @return float
     */
    public function getTankPercentage()
    {
        return $this->tankPercentage;
    }

    /**
     * @param float $tankPercentage
     * @return CreateOrderRequest
     */
    public function withTankPercentage($tankPercentage)
    {
        $new = clone $this;
        $new->tankPercentage = $tankPercentage;

        return $new;
    }

    /**
     * @return string
     */
    public function getRemarks()
    {
        return $this->remarks;
    }

    /**
     * @param string $remarks
     * @return CreateOrderRequest
     */
    public function withRemarks($remarks)
    {
        $new = clone $this;
        $new->remarks = $remarks;

        return $new;
    }

    /**
     * @return string
     */
    public function getTankNo()
    {
        return $this->tankNo;
    }

    /**
     * @param string $tankNo
     * @return CreateOrderRequest
     */
    public function withTankNo($tankNo)
    {
        $new = clone $this;
        $new->tankNo = $tankNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getCommentForTripPlanning()
    {
        return $this->commentForTripPlanning;
    }

    /**
     * @param string $commentForTripPlanning
     * @return CreateOrderRequest
     */
    public function withCommentForTripPlanning($commentForTripPlanning)
    {
        $new = clone $this;
        $new->commentForTripPlanning = $commentForTripPlanning;

        return $new;
    }

    /**
     * @return string
     */
    public function getYourReference()
    {
        return $this->yourReference;
    }

    /**
     * @param string $yourReference
     * @return CreateOrderRequest
     */
    public function withYourReference($yourReference)
    {
        $new = clone $this;
        $new->yourReference = $yourReference;

        return $new;
    }

    /**
     * @return string
     */
    public function getOrderQty()
    {
        return $this->OrderQty;
    }

    /**
     * @param string $OrderQty
     * @return CreateOrderRequest
     */
    public function withOrderQty($OrderQty)
    {
        $new = clone $this;
        $new->OrderQty = $OrderQty;

        return $new;
    }
}
