<?php

namespace MSML\BizTalk\PrimaryContact;

use Soap\ExtSoapEngine\ExtSoapOptions;
use Phpro\SoapClient\Caller\EngineCaller;
use Phpro\SoapClient\Soap\DefaultEngineFactory;
use Phpro\SoapClient\Caller\EventDispatchingCaller;
use Symfony\Component\EventDispatcher\EventDispatcher;

class PrimaryContactClientFactory
{
    public static function factory(string $wsdl) : \MSML\BizTalk\PrimaryContact\PrimaryContactClient
    {
        $engine = DefaultEngineFactory::create(
            ExtSoapOptions::defaults($wsdl, [])
                ->withClassMap(PrimaryContactClassmap::getCollection())
        );

        $eventDispatcher = new EventDispatcher();
        $caller = new EventDispatchingCaller(new EngineCaller($engine), $eventDispatcher);

        return new PrimaryContactClient($caller);
    }
}
