<?php

namespace MSML\BizTalk\PrimaryContact\Type;

use Phpro\SoapClient\Type\RequestInterface;

class RegisterPrimaryContactRequest implements RequestInterface
{
    /**
     * @var string
     */
    private $billingPostalCode;

    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $firstName;

    /**
     * @var string
     */
    private $language;

    /**
     * @var string
     */
    private $lastName;

    /**
     * @var string
     */
    private $navisionNumber;

    /**
     * Constructor
     *
     * @var string $billingPostalCode
     * @var string $email
     * @var string $firstName
     * @var string $language
     * @var string $lastName
     * @var string $navisionNumber
     */
    public function __construct($billingPostalCode, $email, $firstName, $language, $lastName, $navisionNumber)
    {
        $this->billingPostalCode = $billingPostalCode;
        $this->email = $email;
        $this->firstName = $firstName;
        $this->language = $language;
        $this->lastName = $lastName;
        $this->navisionNumber = $navisionNumber;
    }

    /**
     * @return string
     */
    public function getBillingPostalCode()
    {
        return $this->billingPostalCode;
    }

    /**
     * @param string $billingPostalCode
     * @return RegisterPrimaryContactRequest
     */
    public function withBillingPostalCode($billingPostalCode)
    {
        $new = clone $this;
        $new->billingPostalCode = $billingPostalCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return RegisterPrimaryContactRequest
     */
    public function withEmail($email)
    {
        $new = clone $this;
        $new->email = $email;

        return $new;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @param string $firstName
     * @return RegisterPrimaryContactRequest
     */
    public function withFirstName($firstName)
    {
        $new = clone $this;
        $new->firstName = $firstName;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @param string $language
     * @return RegisterPrimaryContactRequest
     */
    public function withLanguage($language)
    {
        $new = clone $this;
        $new->language = $language;

        return $new;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @param string $lastName
     * @return RegisterPrimaryContactRequest
     */
    public function withLastName($lastName)
    {
        $new = clone $this;
        $new->lastName = $lastName;

        return $new;
    }

    /**
     * @return string
     */
    public function getNavisionNumber()
    {
        return $this->navisionNumber;
    }

    /**
     * @param string $navisionNumber
     * @return RegisterPrimaryContactRequest
     */
    public function withNavisionNumber($navisionNumber)
    {
        $new = clone $this;
        $new->navisionNumber = $navisionNumber;

        return $new;
    }
}
