<?php

namespace MSML\BizTalk\PrimaryContact\Type;

use Phpro\SoapClient\Type\ResultInterface;

class RegisterPrimaryContactResponse implements ResultInterface
{
    /**
     * @var string
     */
    private $ContactRef;

    /**
     * @var string
     */
    private $ErrorCode;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @return string
     */
    public function getContactRef()
    {
        return $this->ContactRef;
    }

    /**
     * @param string $ContactRef
     * @return RegisterPrimaryContactResponse
     */
    public function withContactRef($ContactRef)
    {
        $new = clone $this;
        $new->ContactRef = $ContactRef;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }

    /**
     * @param string $ErrorCode
     * @return RegisterPrimaryContactResponse
     */
    public function withErrorCode($ErrorCode)
    {
        $new = clone $this;
        $new->ErrorCode = $ErrorCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return RegisterPrimaryContactResponse
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }
}
