<?php

namespace MSML\BizTalk\ShippingContact;

use Phpro\SoapClient\Caller\Caller;
use Phpro\SoapClient\Type\ResultInterface;
use Phpro\SoapClient\Type\RequestInterface;
use Phpro\SoapClient\Exception\SoapException;

class ShippingContactClient
{
    /**
     * @var Caller
     */
    private $caller;

    public function __construct(\Phpro\SoapClient\Caller\Caller $caller)
    {
        $this->caller = $caller;
    }

    /**
     * @param RequestInterface|Type\RegisterShippingContactRequest $part
     * @return ResultInterface|Type\RegisterShippingContactResponse
     * @throws SoapException
     */
    public function registerShippingContact(\MSML\BizTalk\ShippingContact\Type\RegisterShippingContactRequest $part) : \MSML\BizTalk\ShippingContact\Type\RegisterShippingContactResponse
    {
        return ($this->caller)('RegisterShippingContact', $part);
    }
}
