<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ArrayOfShipToAddress implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\ShipToAddress
     */
    private $ShipToAddress;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'ShipToAddress' => $this->ShipToAddress,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\ShipToAddress $ShipToAddress
     */
    public function __construct($ShipToAddress)
    {
        $this->ShipToAddress = $ShipToAddress;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ShipToAddress
     */
    public function getShipToAddress()
    {
        return $this->ShipToAddress;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ShipToAddress $ShipToAddress
     * @return ArrayOfShipToAddress
     */
    public function withShipToAddress($ShipToAddress)
    {
        $new = clone $this;
        $new->ShipToAddress = $ShipToAddress;

        return $new;
    }
}
