<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetBasicDataQuery implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerNumber;

    /**
     * @var string
     */
    private $LanguageCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerNumber' => $this->CustomerNumber,
            'LanguageCode'   => $this->LanguageCode,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerNumber
     * @var string $LanguageCode
     */
    public function __construct($CustomerNumber, $LanguageCode)
    {
        $this->CustomerNumber = $CustomerNumber;
        $this->LanguageCode = $LanguageCode;
    }

    /**
     * @return string
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }

    /**
     * @param string $CustomerNumber
     * @return GetBasicDataQuery
     */
    public function withCustomerNumber($CustomerNumber)
    {
        $new = clone $this;
        $new->CustomerNumber = $CustomerNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }

    /**
     * @param string $LanguageCode
     * @return GetBasicDataQuery
     */
    public function withLanguageCode($LanguageCode)
    {
        $new = clone $this;
        $new->LanguageCode = $LanguageCode;

        return $new;
    }
}
