<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetCustomerLedgerEntry implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\GetCustomerLedgerEntryQuery
     */
    private $request;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'request' => $this->request,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\GetCustomerLedgerEntryQuery $request
     */
    public function __construct($request)
    {
        $this->request = $request;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\GetCustomerLedgerEntryQuery
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\GetCustomerLedgerEntryQuery $request
     * @return GetCustomerLedgerEntry
     */
    public function withRequest($request)
    {
        $new = clone $this;
        $new->request = $request;

        return $new;
    }
}
