<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetMaterialItemResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfGetMaterialItem
     */
    private $Items;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'ErrorMessage' => $this->ErrorMessage,
            'Items'        => $this->Items,
        ];
    }

    /**
     * Constructor
     *
     * @var string $ErrorMessage
     * @var \MSML\BizTalk\Type\Base\ArrayOfGetMaterialItem $Items
     */
    public function __construct($ErrorMessage, $Items)
    {
        $this->ErrorMessage = $ErrorMessage;
        $this->Items = $Items;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetMaterialItemResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfGetMaterialItem
     */
    public function getItems()
    {
        return $this->Items;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfGetMaterialItem $Items
     * @return GetMaterialItemResult
     */
    public function withItems($Items)
    {
        $new = clone $this;
        $new->Items = $Items;

        return $new;
    }
}
