<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetPriceAndDiscountItem implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfGetDiscountItem
     */
    private $Discount;

    /**
     * @var string
     */
    private $ItemCode;

    /**
     * @var string
     */
    private $ItemDescription;

    /**
     * @var \MSML\BizTalk\Type\Base\GetPriceItem
     */
    private $Price;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Discount'        => $this->Discount,
            'ItemCode'        => $this->ItemCode,
            'ItemDescription' => $this->ItemDescription,
            'Price'           => $this->Price,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\ArrayOfGetDiscountItem $Discount
     * @var string $ItemCode
     * @var string $ItemDescription
     * @var \MSML\BizTalk\Type\Base\GetPriceItem $Price
     */
    public function __construct($Discount, $ItemCode, $ItemDescription, $Price)
    {
        $this->Discount = $Discount;
        $this->ItemCode = $ItemCode;
        $this->ItemDescription = $ItemDescription;
        $this->Price = $Price;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfGetDiscountItem
     */
    public function getDiscount()
    {
        return $this->Discount;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfGetDiscountItem $Discount
     * @return GetPriceAndDiscountItem
     */
    public function withDiscount($Discount)
    {
        $new = clone $this;
        $new->Discount = $Discount;

        return $new;
    }

    /**
     * @return string
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }

    /**
     * @param string $ItemCode
     * @return GetPriceAndDiscountItem
     */
    public function withItemCode($ItemCode)
    {
        $new = clone $this;
        $new->ItemCode = $ItemCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getItemDescription()
    {
        return $this->ItemDescription;
    }

    /**
     * @param string $ItemDescription
     * @return GetPriceAndDiscountItem
     */
    public function withItemDescription($ItemDescription)
    {
        $new = clone $this;
        $new->ItemDescription = $ItemDescription;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\GetPriceItem
     */
    public function getPrice()
    {
        return $this->Price;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\GetPriceItem $Price
     * @return GetPriceAndDiscountItem
     */
    public function withPrice($Price)
    {
        $new = clone $this;
        $new->Price = $Price;

        return $new;
    }
}
