<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class RegisterUserResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'ErrorMessage' => $this->ErrorMessage,
            'ReturnCode'   => $this->ReturnCode,
        ];
    }

    /**
     * Constructor
     *
     * @var string $ErrorMessage
     * @var string $ReturnCode
     */
    public function __construct($ErrorMessage, $ReturnCode)
    {
        $this->ErrorMessage = $ErrorMessage;
        $this->ReturnCode = $ReturnCode;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return RegisterUserResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return RegisterUserResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
