# Business Central Service

## Installation

You can install the package via composer:

```bash
composer require msml/business-central-service
```

You can publish the config file with:

```bash
php artisan vendor:publish --tag="business-central-service-config"
```

## Usage

```php
use MSML\BusinessCentralService\Services\BusinessCentralService;

$service = new BusinessCentralService($options);
```

#### Some small examples
Depending on integration in Business Central.
```php
// Get a customer on `no`.
$service->endpoint('contacts')->firstWhere('no', $externalId);

// Update a contact based on the `systemId`.
$service
    ->endpoint('contacts')
    ->withVersionTag($force ? '*' : $etag)
    ->onVersionMismatch(fn () => { })
    ->patch($systemId, $body);
```

#### Options
Options can be added with:
```php
  ->setOption('key', 'value')
```

Default options:
| Option                                                              | Type                | Default     |
| ------------------------------------------------------------------- | ------------------- | :-------:   |
| `log`                                                               | `boolean`           | `true`      |
| `throw`                                                             | `boolean`           | `true`      |
| `report`                                                            | `boolean`           | `true`      |
| `path`                                                              | `string`            | `'default'` |
