<?php

namespace MSML\BusinessCentralService\Services\Query;

use MSML\BusinessCentralService\Services\BusinessCentralService;
use MSML\BusinessCentralService\Services\Query\Traits\CastsValues;
use MSML\BusinessCentralService\Services\Query\Traits\GetOperations;
use MSML\BusinessCentralService\Services\Query\Traits\InsertOperations;
use MSML\BusinessCentralService\Services\Query\Traits\UpdateDeleteOperations;

class BusinessCentralQueryBuilder
{
    use CastsValues, GetOperations, InsertOperations, UpdateDeleteOperations;

    /**
     * The compiled query parameters to be added to any request.
     */
    private array $queryParams = [];

    /**
     * Create a new query builder instance.
     */
    public function __construct(public BusinessCentralService|null $service = null, public string|null $endpoint = null)
    {
        //
    }

    /**
     * Set the target endpoint for the query builder.
     */
    public function setEndpoint(string $endpoint): self
    {
        $this->endpoint = $endpoint;

        return $this;
    }
}
