<?php

namespace MSML\BusinessCentralService\Services\Query\Traits;

use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;

trait CastsValues
{
    /**
     * Determine whether the response values should be case to a more appropriate format.
     */
    private bool $castValues = true;

    /**
     * Indicate that the response value casting should be skipped.
     */
    public function bypassCasts(): self
    {
        $this->castValues = false;

        return $this;
    }

    /**
     * Cast the given values according to the pre-defined config.
     */
    private function processCasts(Collection $data): Collection
    {
        $data->transform(function ($item) {
            if (!is_array($item)) {
                return $item;
            }

            return collect($item)->map(function ($value, $key) {
                if ($globalCast = config("business-central-service.casts.global.{$key}")) {
                    $value = self::cast($value, $globalCast);
                }

                $endpoint = $this->endpoint;

                if ($endpointCast = config("business-central-service.casts.endpoints.{$endpoint}.{$key}")) {
                    $value = self::cast($value, $endpointCast);
                }

                if (gettype($value) === 'string' && empty($value)) {
                    return null;
                }

                return $value;
            })->toArray();
        });

        return $data;
    }

    /**
     * Perform certain casting on a given value.
     */
    private static function cast(mixed $value, string $cast): mixed
    {
        $method = match ($cast) {
            'datetime' => 'castDateTime',
            'date'     => 'castDateTime',
            default    => null,
        };

        if (!$method) {
            return $value;
        }

        return self::{$method}($value);
    }

    /**
     * Cast a given value to a dateTime format.
     */
    private static function castDateTime(mixed $value): mixed
    {
        try {
            $value = Carbon::make($value);
        } catch (\Throwable $e) {
            //
        }

        return $value;
    }
}
