<?php

namespace MSML\BusinessCentralService\Services\Traits;

use Exception;

trait ChecksConfig
{
    /**
     * Throw a descriptive exception if a required configuration value is missing.
     */
    private function ensureNoConfigValuesAreMissing($config): void
    {
        collect(config($config))
            ->each(function ($value, $key) use ($config) {
                if (!$value) {
                    throw new Exception(sprintf('Missing required config value: `%s.%s`', $config, $key));
                }
            });
    }
}
