<?php

namespace MSML\BusinessCentralService\Middleware;

use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use MSML\HttpClient\Middleware\HttpClientMiddleware;

final class BusinessCentralMiddleware extends HttpClientMiddleware
{
    /**
     * Get the log message specifically based on the BC API response.
     */
    protected function getLogMessage(RequestInterface $request, ResponseInterface $response): string
    {
        return $response->getReasonPhrase()
            ? 'Business Central HTTP request error: ' . $response->getReasonPhrase()
            : 'Business Central HTTP request error';
    }
}
